<?php
session_start();

// ---------------- SECURITY ----------------
if (!isset($_SESSION['client_id'])) {
    echo "Unauthorized";
    exit();
}

// ---------------- ERROR REPORTING ----------------
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ---------------- DB CONNECTION ----------------
$host = "localhost";
$user = "thevkin_schlautdb";
$pass = "VK_AutSchlDb";
$db   = "thevkin_schlautdb";

$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) die("DB Err: " . mysqli_connect_error());

$msg = "";
$cls = "";
$created_by = $_SESSION['client_id'];


/* ============================================================
   FIXED — PERFECT PRINCIPAL ID GENERATOR
   #VKPR01 → #VKPR02 → #VKPR03 (no duplicates)
   ============================================================ */
function generatePrincipalID($conn)
{
    $q = "
        SELECT id 
        FROM principals
        WHERE id LIKE '#VKPR%'
        ORDER BY CAST(SUBSTRING(id, 6) AS UNSIGNED) DESC
        LIMIT 1
    ";

    $res = mysqli_query($conn, $q);

    if (!$res || mysqli_num_rows($res) == 0) {
        return "#VKPR01";
    }

    $row = mysqli_fetch_assoc($res);
    preg_match('/^#VKPR(\d+)$/', $row['id'], $m);

    $num = intval($m[1]) + 1;
    return "#VKPR" . str_pad($num, 2, "0", STR_PAD_LEFT);
}


/* ============================================================
   LOAD BRANCHES CREATED BY THIS CLIENT
   ============================================================ */
$branches = [];
$branch_sql = "SELECT id, name FROM branches WHERE created_by='$created_by' ORDER BY name ASC";
$branch_res = mysqli_query($conn, $branch_sql);

if ($branch_res && mysqli_num_rows($branch_res) > 0) {
    while ($b = mysqli_fetch_assoc($branch_res)) {
        $branches[] = $b;
    }
}


/* ============================================================
   INSERT PRINCIPAL — FULLY FIXED
   ============================================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_principal'])) {

    $first_name   = trim($_POST['first_name']);
    $last_name    = trim($_POST['last_name']);
    $email        = trim($_POST['email']);
    $username     = trim($_POST['username']);
    $password_raw = $_POST['password'];
    $password     = password_hash($password_raw, PASSWORD_DEFAULT);
    $phone        = trim($_POST['phone']);
    $partnered_on = $_POST['partnered_on'];
    $branch_id    = $_POST['branch_id'];

    // Required fields validation
    if ($first_name === "" || $last_name === "" || $email === "" || $username === "") {
        $msg = "Please fill all required fields.";
        $cls = "error";
    } else {

        // NEW UNIQUE PRINCIPAL ID
        $principal_id = generatePrincipalID($conn);

        // PHOTO UPLOAD
        $photo_name = null;
        if (!empty($_FILES['photo']['name'])) {

            $photo_name = time() . "_" . basename($_FILES['photo']['name']);

            if (!is_dir("uploads")) {
                mkdir("uploads", 0777, true);
            }

            move_uploaded_file($_FILES['photo']['tmp_name'], "uploads/" . $photo_name);
        }

        // PREPARE INSERT
        $sql = "
            INSERT INTO principals
            (id, first_name, last_name, email, username, password, phone, photo, partnered_on, branch_id, created_by, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ";

        $stmt = mysqli_prepare($conn, $sql);

        mysqli_stmt_bind_param(
            $stmt,
            "sssssssssss",
            $principal_id,
            $first_name,
            $last_name,
            $email,
            $username,
            $password,
            $phone,
            $photo_name,
            $partnered_on,
            $branch_id,
            $created_by
        );

        // FINAL EXECUTE
        if (mysqli_stmt_execute($stmt)) {
            $msg = "Principal added successfully! ID: $principal_id";
            $cls = "success";
        } else {
            $msg = "DB Error: " . mysqli_stmt_error($stmt);
            $cls = "error";
        }

        mysqli_stmt_close($stmt);
    }
}
?>

<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Add Principal</title>

    <style>
        body {
            font-family: Inter, Arial;
            background: #f4f6ff;
            padding: 18px;
        }
        .box {
            max-width: 650px;
            margin: 10px auto;
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        }
        input, select, button {
            width: 100%;
            padding: 12px;
            margin-top: 10px;
            border-radius: 8px;
            border: 1px solid #ccc;
            font-size: 15px;
        }
        button {
            background: #0077ff;
            color: #fff;
            border: 0;
            cursor: pointer;
        }
        .success {
            background: #e6ffec;
            padding: 10px;
            border-radius: 6px;
            color: #1d6d2e;
            margin-bottom: 10px;
        }
        .error {
            background: #ffe6e6;
            padding: 10px;
            border-radius: 6px;
            color: #8a1f1f;
            margin-bottom: 10px;
        }
    </style>
</head>

<body>

<div class="box">
    <h3>Add Principal</h3>

    <?php if ($msg !== ""): ?>
        <div class="<?php echo $cls; ?>">
            <?php echo htmlspecialchars($msg); ?>
        </div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">

        <input type="text" name="first_name" placeholder="First Name" required>
        <input type="text" name="last_name" placeholder="Last Name" required>
        <input type="email" name="email" placeholder="Email" required>
        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>
        <input type="text" name="phone" placeholder="Phone Number">
        <input type="date" name="partnered_on">

        <select name="branch_id" required>
            <option value="">Select Branch</option>
            <?php foreach ($branches as $b): ?>
                <option value="<?php echo $b['id']; ?>">
                    <?php echo htmlspecialchars($b['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <input type="file" name="photo" accept="image/*">

        <button name="submit_principal" type="submit">Add Principal</button>
    </form>
</div>

</body>
</html>
