<?php
// PHP backend setup for session management and user data fetching
session_start();
// client_id మరియు user_data రెండూ ఉన్నాయో లేదో చెక్ చేయండి
if(!isset($_SESSION['client_id']) || !isset($_SESSION['user_data'])){
    header("Location: login.php");
    exit();
}

// DB కనెక్షన్
$host = "localhost";
$user = "thevkin_schlautdb";
$pass = "VK_AutSchlDb";
$db = "thevkin_schlautdb";
$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) die("DB Error: " . mysqli_connect_error());

// ప్రస్తుత పేజీని $page వేరియబుల్ లోకి తీసుకోండి
$page = isset($_GET['page']) ? $_GET['page'] : 'profile';

// సెషన్ నుండి యూజర్ డేటాను తీసుకోండి
$user_data = $_SESSION['user_data'];
// 🚨 భద్రత మెరుగుదల: XSS నివారణ కోసం htmlspecialchars ఉపయోగించండి
$name = htmlspecialchars($user_data['first_name'] . ' ' . $user_data['last_name'] ?? 'Stakeholder');
$photo = htmlspecialchars($user_data['photo'] ?? '');

$path = "uploads/".$photo;
if(!file_exists($path) || empty($photo)) $path="uploads/default.png";

// Active page name for JS/CSS
$active_page_file = $page . '.php'; 
// ప్రస్తుత పేజీకి నావిగేషన్ లింక్ (క్లాస్ సెట్ చేయడానికి)
$current_link = 'dashboard.php?page=' . $page;
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Stakeholder Dashboard</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

<style>
/* ==================================================== */
/* GLOBAL & MOBILE-FIRST STYLES (Full App Look) */
/* ==================================================== */

html { height: 100%; }
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    -webkit-tap-highlight-color: transparent;
}

:root {
    /* Colors matching Super Admin Look for consistency */
    --primary-color: #1a56db; /* Blue */
    --secondary-color: #172554; /* Dark Blue */
    --text-dark: #1f2937;
    --text-light: #f3f4f6;
    /* Dimensions increased for App Feel (Matching Super Admin) */
    --header-height-mobile: 80px;
    --header-height-desktop: 80px;
    --sidebar-width: 280px;
    --bottom-nav-height: 80px;
}

body {
    font-family: "Poppins", sans-serif;
    display: flex;
    flex-direction: column;
    height: 100dvh; /* Use dynamic height */
    background: #f1f5f9;
    overflow: hidden;
}

.app-container {
    display: flex;
    flex-direction: column;
    width: 100%;
    height: 100%;
    position: relative;
}

/* ==================================================== */
/* 1. TOP PANEL (Header - Mobile Optimized, App Look) */
/* ==================================================== */

.top-panel {
    height: var(--header-height-mobile); /* Big Header */
    background: #ffffff;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 20px;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    z-index: 1000;
}

/* Branding with Logo and Text (Matching Super Admin) */
.header-branding {
    display: flex;
    align-items: center;
    gap: 12px;
}
.header-branding img {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    object-fit: cover;
}
.branding-info h4 {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--text-dark);
}
.branding-info p {
    font-size: 0.9rem;
    color: #6b7280;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 10px;
}

/* Profile Box (Mobile) - Profile Picture is bigger */
.profile-box { cursor: pointer; }
.profile-box img {
    width: 50px;
    height: 50px;
    border: 4px solid var(--primary-color);
    border-radius: 50%;
    object-fit: cover;
    transition: transform 0.2s;
}
.profile-info, .logout-btn, .top { display: none; } /* Hide desktop/old elements */


/* ==================================================== */
/* 2. MAIN CONTENT WRAPPER (Mobile View) */
/* ==================================================== */

.main-wrapper {
    display: flex;
    flex-direction: column;
    width: 100%;
    flex: 1;

    /* PADDING: Adjusted for header and bottom navigation */
    padding-top: var(--header-height-mobile);
    padding-bottom: var(--bottom-nav-height);

    height: 100%;
    overflow-y: auto;
}

/* Hide Sidebar/Left Panel on Mobile */
.left-panel {
    display: none;
}

/* Right Content Area (Actual Content Div) on Mobile - Full Bleed */
.right-content {
    flex: 1;
    /* Important: Remove padding here to allow full-width content (Mobile App Look) */
    padding: 0; 
    background: #f1f5f9;
}

/* IMPORTANT: Target the content-area for included files
   In Mobile App view, we want the content to use the full width
   If you have a card inside your included files, it should have its own padding/margin. */
.content-area {
    /* Remove padding/background/shadow wrapper to ensure full width */
    background: transparent;
    padding: 0; 
    box-shadow: none;
}


/* ==================================================== */
/* BOTTOM NAVIGATION BAR (Mobile App Look - Large Icons/Text) */
/* ==================================================== */

.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    height: var(--bottom-nav-height); 
    background: #ffffff;
    display: flex;
    justify-content: space-around;
    align-items: center;
    border-top: 1px solid #e2e8f0;
    box-shadow: 0 -4px 15px rgba(0, 0, 0, 0.15);
    z-index: 2000;
}

.bottom-nav a {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-decoration: none;
    color: #6b7280;
    flex: 1;
    height: 100%;
    transition: color 0.3s ease, transform 0.3s ease, background-color 0.3s ease;
    font-size: 0.9rem;
    font-weight: 500;
    padding: 5px;
}

.bottom-nav a i {
    font-size: 2.2rem; /* Large App Icon Size */
    margin-bottom: 2px;
}

.bottom-nav a.active {
    color: var(--primary-color);
    font-weight: 600;
    transform: translateY(-4px); 
    background-color: #f0f4ff;
    border-radius: 8px 8px 0 0;
}

.bottom-nav a:active {
    background-color: #e5e9f2;
}


/* ==================================================== */
/* DESKTOP (>= 1024px) STYLES - Matched to Super Admin */
/* ==================================================== */

@media (min-width: 1024px) {

    body { flex-direction: row; }
    .top-panel { display: none; }
    .main-wrapper {
        flex-direction: row;
        padding: 0;
        height: 100%;
        overflow: hidden;
    }

    /* Left Panel (Sidebar - Desktop Only, SA Style) */
    .left-panel {
        display: flex;
        width: var(--sidebar-width);
        background: linear-gradient(180deg, #1e40af 0%, var(--secondary-color) 100%);
        box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        flex-direction: column;
        color: var(--text-light);
        flex-shrink: 0;
    }

    .left-panel h2 {
        padding: 24px;
        margin: 0;
        font-size: 1.5rem;
        font-weight: 700;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        color: var(--text-light);
    }

    .sidebar-menu {
        padding: 20px 10px;
        flex: 1;
        overflow-y: auto;
    }
    .sidebar-menu a {
        color: rgba(255, 255, 255, 0.85);
        padding: 12px 15px;
        border-radius: 8px;
        margin-bottom: 5px;
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 0.95rem;
        text-decoration: none;
        transition: background 0.2s ease;
    }
    .sidebar-menu a i { font-size: 1.2rem; }
    .sidebar-menu a:hover:not(.active) { background: rgba(255, 255, 255, 0.08); }
    .sidebar-menu a.active {
        background: var(--primary-color);
        box-shadow: 0 4px 8px rgba(26, 86, 219, 0.3);
        font-weight: 500;
        color: #fff;
    }

    /* Right Content Area */
    .right-content {
        padding: 0;
        flex: 1;
        display: flex;
        flex-direction: column;
        overflow-y: auto;
    }

    /* Desktop Header */
    .top {
        display: flex; 
        height: var(--header-height-desktop);
        background: #fff;
        border-bottom: 1px solid #e2e8f0;
        align-items: center;
        justify-content: flex-end;
        padding: 0 40px;
        flex-shrink: 0;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.04);
    }
    .top .profile-box {
        display: flex;
        gap: 10px;
        background: #f8fafc;
        padding: 8px 15px;
        border-radius: 50px;
        border: 1px solid #e2e8f0;
        cursor: pointer;
    }
    .top .profile-box img {
        width: 45px;
        height: 45px;
        border: none;
    }
    .top .profile-info {
        display: flex;
        flex-direction: column;
        justify-content: center;
        margin-right: 0;
    }
    .top .name { font-weight: 600; font-size: 1rem; color: var(--text-dark); }
    .top .role { font-size: 0.8rem; color: #6b7280; }
    
    .content-area {
        flex: 1;
        padding: 30px; /* Padding applied to content area wrapper on desktop */
        overflow-y: auto;
    }

    /* Hide Mobile Bottom Nav */
    .bottom-nav { display: none; }
}
</style>

<script>
// Function to update the active state of navigation links
function setActiveLink(url) {
    // Extract only the part after 'page=' (e.g., "profile", "add_branch")
    const urlObject = new URL(url, window.location.href);
    const params = new URLSearchParams(urlObject.search);
    const targetPage = params.get('page') || 'profile'; // Default to 'profile'

    // 1. Sidebar Links (Desktop)
    document.querySelectorAll('.sidebar-menu a').forEach(a => a.classList.remove('active'));
    const sidebarLink = document.querySelector(`.sidebar-menu a[href*="page=${targetPage}"]`);
    if (sidebarLink) {
        sidebarLink.classList.add('active');
    }

    // 2. Bottom Nav Links (Mobile)
    document.querySelectorAll('.bottom-nav a').forEach(a => a.classList.remove('active'));
    const bottomNavLink = document.querySelector(`.bottom-nav a[href*="page=${targetPage}"]`);
    if (bottomNavLink) {
        bottomNavLink.classList.add('active');
    }
}

// Initial setup
document.addEventListener('DOMContentLoaded', function() {
    // Set initial active state based on the current PHP-determined page
    const initialPage = "<?php echo $current_link; ?>";
    setActiveLink(initialPage);

    // Profile click logic (for both mobile icon and desktop info box)
    const profileBoxes = document.querySelectorAll('.profile-box');
    profileBoxes.forEach(box => {
        box.addEventListener('click', function() {
            window.location.href = "dashboard.php?page=profile";
        });
    });
});
</script>

</head>
<body>

<div class="app-container">

    <div class="top-panel">
        <div class="header-branding">
            <img src="uploads/logo_stakeholder.png" alt="SH Logo">
            <div class="branding-info">
                <h4>VK Stakeholder</h4>
                <p>Management Panel</p>
            </div>
        </div>
        <div class="header-right">
            <div class="profile-box">
                <img src="<?php echo $path; ?>" alt="<?php echo $name; ?>">
            </div>
        </div>
    </div>

    <div class="main-wrapper">

        <div class="left-panel">
            <h2>Stakeholder</h2>
            <div class="sidebar-menu">
                <a href="dashboard.php?page=profile" class="<?php echo ($page === 'profile' ? 'active' : ''); ?>">
                    <i class="bi bi-person-circle"></i>
                    <span>Profile</span>
                </a>
                <a href="dashboard.php?page=add_branch" class="<?php echo ($page === 'add_branch' ? 'active' : ''); ?>">
                    <i class="bi bi-geo-alt-fill"></i>
                    <span>Manage Branches</span>
                </a>
                <a href="dashboard.php?page=add_principal" class="<?php echo ($page === 'add_principal' ? 'active' : ''); ?>">
                    <i class="bi bi-people-fill"></i>
                    <span>Manage Principals</span>
                </a>
                <a href="logout.php">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>

        <div class="right-content">
            <div class="top">
                <div class="profile-box">
                    <img src="<?php echo htmlspecialchars($path); ?>" alt="photo">
                    <div class="profile-info">
                        <span class="name"><?php echo htmlspecialchars($name); ?></span>
                        <span class="role">Stakeholder</span>
                    </div>
                </div>
                <a class="logout-btn" href="logout.php" style="display: none;">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Logout</span>
                </a>
            </div>

            <div class="content-area">
                <?php
                // ఇంక్లూడ్ అయ్యే పేజీలకు $conn మరియు $user_data అందుబాటులో ఉంటాయి
                if($page==='profile'){
                    include 'profile.php';
                }elseif($page==='add_branch'){
                    include 'add_branch.php';
                }
                elseif($page==='add_principal'){
                    include 'add_principal.php';
                }else{
                    echo "<h3>Page Not Found</h3>";
                }
                ?>
            </div>
        </div>
    </div>

    <div class="bottom-nav">

        <a href="dashboard.php?page=profile" class="<?php echo ($page === 'profile' ? 'active' : ''); ?>">
            <i class="bi bi-person-circle"></i>
            <span>Profile</span>
        </a>

        <a href="dashboard.php?page=add_branch" class="<?php echo ($page === 'add_branch' ? 'active' : ''); ?>">
            <i class="bi bi-geo-alt-fill"></i>
            <span>Branches</span>
        </a>

        <a href="dashboard.php?page=add_principal" class="<?php echo ($page === 'add_principal' ? 'active' : ''); ?>">
            <i class="bi bi-people-fill"></i>
            <span>Principals</span>
        </a>

        <a href="logout.php">
            <i class="bi bi-box-arrow-right"></i>
            <span>Logout</span>
        </a>
    </div>
</div>

</body>
</html>